/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.upgrddat;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class UpgradeDataBSample3
implements UpgradeData {
    private static final String TRACE_MASKT = "XSAVBS3T";
    private static final String TRACE_MASKF = "XSAVBS3F";
    private static final String TRACE_MASKD = "XSAVBS3D";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(3, "UpgradeDataBSample3");
    private static final short ERRID_4081 = 16513;
    private static final short ERRID_4082 = 16514;
    private String versionNumber = "00001";

    public UpgradeDataBSample3() {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataBSample3() Constructor");
        Trace.trace(TRACE_MASKT, "<- UpgradeDataBSample3() Constructor");
    }

    public String getUpgradeDataVersion() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataBSample3.getUpgradeDataVersion()");
        Trace.trace(TRACE_MASKF, "Version number is : " + this.versionNumber);
        Trace.trace(TRACE_MASKT, "<- UpgradeDataBSample3.getUpgradeDataVersion()");
        return this.versionNumber;
    }

    public void saveUpgradeData(OutputStream streamNameOut) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataBSample3.saveUpgradeData(OutputStream StreamNameOut)");
        Trace.trace(TRACE_MASKF, "Output stream passed in is: " + streamNameOut);
        try {
            Properties props = new Properties();
            props.put("saveitem1", "Save sample3 data 31");
            props.put("saveitem2", "Save sample3 data 32");
            props.put("saveitem3", "Save sample3 data 33");
            props.store(streamNameOut, "Dan's test properties file");
            Trace.trace(TRACE_MASKF, "Properties file data was put in :" + streamNameOut);
        }
        catch (IOException exc) {
            Trace.trace(TRACE_MASKF, "An IOException occurred" + streamNameOut);
            Trace.trace(TRACE_MASKF, exc);
            UpgradeDataException hexc = new UpgradeDataException(exc);
            hexc.setCriticalDataError();
            new FrameworkLog(_logInfo, 16513, hexc).log();
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataBSample3.saveUpgradeData(OutputStream StreamNameOut)");
    }

    public void restoreUpgradeData(InputStream streamNameIn, String versionLevel) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataBSample3.restoreUpgradeData(streamName, version)");
        Trace.trace(TRACE_MASKF, "Input stream passed in is: " + streamNameIn);
        Trace.trace(TRACE_MASKF, "Version level passed in is : " + versionLevel);
        try {
            Properties props = new Properties();
            props.load(streamNameIn);
            Trace.trace(TRACE_MASKF, "There are " + props.size() + " items in the properties list");
            Trace.trace(TRACE_MASKF, "Properties file data items are :" + props.toString());
        }
        catch (IOException exc) {
            Trace.trace(TRACE_MASKF, "An IOException occurred" + streamNameIn);
            Trace.trace(TRACE_MASKF, exc);
            UpgradeDataException hexc = new UpgradeDataException(exc);
            hexc.setCriticalDataError();
            new FrameworkLog(_logInfo, 16514, hexc).log();
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataBSample3.restoreUpgradeData(streamName, version)");
    }
}

